function cmap = genColormap(steps)
% --- Colormap more appropriate than jet for calcium imaging

cmap = zeros(steps, 3);
setStep = round(steps/5);
cnt = 1;
for i=1:setStep
    cmap(cnt,:) = [0 0 round(i/setStep*255)];
    cnt = cnt + 1;
end
for i=1:setStep
    cmap(cnt,:) = [0 round(i/setStep*255) 255];
    cnt = cnt + 1;
end
for i=1:setStep
    cmap(cnt,:) = [0 255 255-round(i/setStep*255)];
    cnt = cnt + 1;
end
for i=1:setStep
    cmap(cnt,:) = [round(i/setStep*255) 255 0];
    cnt = cnt + 1;
end
for i=1:setStep
    cmap(cnt,:) = [255 255-round(i/setStep*255) 0];
    cnt = cnt + 1;
end
cmap = cmap ./ 255;